/* Copyright (C) 2002-2018 RealVNC Ltd.  All Rights Reserved.
*/

#ifndef __MIRRORLINKKEYSYMDEF_H__
#define __MIRRORLINKKEYSYMDEF_H__

/**
 * \file mirrorlinkkeysymdef.h
 *
 * This file defines additional X key symbols for use with MirrorLink&reg;
 *
 * This file is included by vncmirrorlink.h.  You should normally include
 * vncmirrorlink.h instead of including this file directly.
 *
 * Note that devices are only likely to respond to particular key events if
 * their operating system understands the idea behind the key event in
 * question.  For example, sending XK_Device_Backward to a device whose
 * operating system does not expect the device to have a physical 'back' key is
 * unlikely to have an effect.
 *
 * Refer to Appendix A, 'Event Mapping', in the MirrorLink specification, for
 * further information, and to %mirrorlinkkeysymdef.h itself for a full list of
 * constants.
 *
 * MirrorLink is a registered trademark of Car Connectivity Consortium in the
 * US and other countries.
 *
 * \section mirrorlinkkeysymdef_knobs About knobs
 *
 * MirrorLink servers support up to four 2D knobs as input devices.  The key
 * symbol constants for knob input are generated by the XK_Knob_2D_*(n)
 * family of macros, all of which require an integer parameter.  This parameter
 * should be in the range 0 to 3 inclusive.
 *
 * In the case of knob rotation, there is one macro for clockwise rotation and
 * one macro for counter-clockwise rotation about each axis.  Clockwise
 * rotation is denoted by the axis name in lower-case (e.g.
 * XK_Knob_2D_rotate_x) and counter-clockwise rotation is denoted by the axis
 * name in upper-case (e.g. XK_Knob_2D_rotate_X).
 *
 * \see VNCServerEventConfiguration, VNCClientEventConfiguration,
 * VNCKnobKeySupport, VNCDeviceStatusRequest, VNCMultimediaKeySupport,
 * VNCViewerSendKeyEvent()
 */

/** \cond */

#define XK_Knob_2D_shift_right(n)      (0x30000000 | (((n) << 4)))
#define XK_Knob_2D_shift_left(n)       (0x30000001 | (((n) << 4)))
#define XK_Knob_2D_shift_up(n)         (0x30000002 | (((n) << 4)))
#define XK_Knob_2D_shift_up_right(n)   (0x30000003 | (((n) << 4)))
#define XK_Knob_2D_shift_up_left(n)    (0x30000004 | (((n) << 4)))
#define XK_Knob_2D_shift_down(n)       (0x30000005 | (((n) << 4)))
#define XK_Knob_2D_shift_down_right(n) (0x30000006 | (((n) << 4)))
#define XK_Knob_2D_shift_down_left(n)  (0x30000007 | (((n) << 4)))
#define XK_Knob_2D_shift_push(n)       (0x30000008 | (((n) << 4)))
#define XK_Knob_2D_shift_pull(n)       (0x30000009 | (((n) << 4)))
#define XK_Knob_2D_rotate_x(n)         (0x3000000A | (((n) << 4)))
#define XK_Knob_2D_rotate_X(n)         (0x3000000B | (((n) << 4)))
#define XK_Knob_2D_rotate_y(n)         (0x3000000C | (((n) << 4)))
#define XK_Knob_2D_rotate_Y(n)         (0x3000000D | (((n) << 4)))
#define XK_Knob_2D_rotate_z(n)         (0x3000000E | (((n) << 4)))
#define XK_Knob_2D_rotate_Z(n)         (0x3000000F | (((n) << 4)))

#define XK_ITU_Key_0       0x30000100
#define XK_ITU_Key_1       0x30000101
#define XK_ITU_Key_2       0x30000102
#define XK_ITU_Key_3       0x30000103
#define XK_ITU_Key_4       0x30000104
#define XK_ITU_Key_5       0x30000105
#define XK_ITU_Key_6       0x30000106
#define XK_ITU_Key_7       0x30000107
#define XK_ITU_Key_8       0x30000108
#define XK_ITU_Key_9       0x30000109
#define XK_ITU_Key_Asterix 0x3000010A
#define XK_ITU_Key_Pound   0x3000010B

#define XK_Device_Phone_call  0x30000200
#define XK_Device_Phone_end   0x30000201
#define XK_Device_Soft_left   0x30000202
#define XK_Device_Soft_middle 0x30000203
#define XK_Device_Soft_right  0x30000204
#define XK_Device_Application 0x30000205
#define XK_Device_Ok          0x30000206
#define XK_Device_Delete      0x30000207
#define XK_Device_Zoom_in     0x30000208
#define XK_Device_Zoom_out    0x30000209
#define XK_Device_Clear       0x3000020A
#define XK_Device_Forward     0x3000020B
#define XK_Device_Backward    0x3000020C
#define XK_Device_Home        0x3000020D
#define XK_Device_Search      0x3000020E
#define XK_Device_Menu        0x3000020F

#define XK_Function_Key(n) (0x30000300 + (n))

#define XK_Multimedia_Play     0x30000400
#define XK_Multimedia_Pause    0x30000401
#define XK_Multimedia_Stop     0x30000402
#define XK_Multimedia_Forward  0x30000403
#define XK_Multimedia_Rewind   0x30000404
#define XK_Multimedia_Next     0x30000405
#define XK_Multimedia_Previous 0x30000406
#define XK_Multimedia_Mute     0x30000407
#define XK_Multimedia_Unmute   0x30000408
#define XK_Multimedia_Photo    0x30000409

/** \endcond */

#endif /* !defined(__MIRRORLINKKEYSYMDEF_H__) */
